#!/bin/bash
#SBATCH --nodes=1
#SBATCH --partition=n12

Code_Path=`pwd`
MCS=20 # MC steps per site per cycle
RE=1 # 1 for replica exchange, otherwise no replica exchange
NMC=5000 # MC cycles
l=4 # Size of cells
N=$(expr 2 \* $l \* $l \* $l)
Efile=${Code_Path}/MoNbTaW_tetEs.txt
#echo $l > size
echo $N > Natoms
#echo $MCS > MCS

if [ -e Nrun ]; then Nrun=`cat Nrun`; else Nrun=0; fi

echo Start at `date` > RunAt 
echo Job-ID  $SLURM_JOB_ID >> RunAt
echo Directory is `pwd` >> RunAt
echo Host is `hostname` >> RunAt
echo Nrun is $Nrun >> RunAt

# Outermost loop
for Ncycle in $(seq 1 $NMC) ; do
 
  # `touch HALT` to stop the run
  if [ -f ./HALT ]; then echo Halting at N=$Nrun >> RunAt; exit; fi
  
  fmt_Nrun=`printf "%05d" $Nrun`

  # Start each MC cycle in its respective run directory, then wait for
  # them all to finish.
  for r in run* ; do
    cd $r
    ${Code_Path}/bcctetMC.bin $l `cat Trun` $MCS --energies $Efile --infile MCin -w >> output &
    cd -
  done
  wait

  for r in run* ; do
    # Post-MC processing: rename/organize/move files
    # in preparation for replica exchange.
    cd $r
    echo ${fmt_Nrun} `cat Trun` >> mc_Tvst.dat
    #${Code_Path}/mcrename $fmt_Nrun $(printf "%04d" `cat Trun`)
    cp MCout MCout_N${fmt_Nrun}_T$(printf "%04d" `cat Trun`)
    mv MCout MCin
    cd -
  done

  #### replica exchange goes below #### 
  if [[ "$RE" -eq "1" ]]; then ./replica-exchange.bin $l --energies $Efile >> out.remc; fi

  let Nrun++
  echo $Nrun > Nrun

done
echo Done at `date` >> RunAt
