#!/usr/bin/python3
import numpy as np
import argparse

parser = argparse.ArgumentParser(description='A tool that, given a sequence of integers generated by `comp-dir.py` as INFILE,\
        restores the configuration to the proper format and writes it to OUTFILE.')

parser.add_argument('L', type=int, help='length input for N=2(L^3) atom configuration')
parser.add_argument('INFILE', metavar='INFILE', help='sequence of N integers generated by `comp-dir.py` that represent\
        a decoration of a BCC lattice with N sites')
parser.add_argument('OUTFILE', metavar='OUTFILE', help='path to output, which is the same \
        configuration in a format usable by our MC code')
args = parser.parse_args()

l=args.L; L=2*l; N=2*(L**3)

with open(args.INFILE, 'r') as InFile:
    comp=InFile.readline()
    InFile.close()

cfg=[*comp]
cfg.pop()
cfg=np.array(cfg, dtype=int)
sig=np.zeros((L,L,L),dtype=int)
for i in range(L):
    p=i%2; a=i*(l**2); b=(i+1)*(l**2)
    sig[i,p::2,p::2]=cfg[a:b].reshape((l,l))
with open(args.OUTFILE, 'w') as OutFile:
    for slice in sig:
        np.savetxt(OutFile, slice, fmt='%1d')
        OutFile.write('\n')
    OutFile.close()
