#!/usr/bin/python3
import numpy as np
import glob
import argparse

parser = argparse.ArgumentParser(description='A tool to slightly compress and consolidate all MC configuration files in a given\
        directory (matching the pattern "MCout_N*").')
parser.add_argument('L', type=int, help='length input for N=2(L^3) atom configuration')
parser.add_argument('dir', type=str, help='path to directory containing MC files to compress')
args = parser.parse_args()

l=args.L; L=2*l; N=2*(L**3)

outs = glob.glob(args.dir+'/MCout_N*')
for out in outs:
    with open(out, 'r') as InFile:
        cfg=np.loadtxt(InFile, dtype=int)
        InFile.close()
    print(*cfg[cfg != 0], sep='')
