#!/usr/bin/python
# syntax: ./mc2xyz.py leng (MC config file)
import sys
import numpy as np

leng=int(sys.argv[1])
L = 2*leng
N = 2*(leng**3)
mcfile=sys.argv[2]

allCoords = []
for l in range(L):
    for r in range(L):
        for c in range(L):
            if l%2==r%2==c%2:
                allCoords.append((l,r,c))

with open(mcfile,'r') as MC:
    sig = np.loadtxt(mcfile, dtype=int).reshape((L,L,L))

species = {1:(42, 'Mo'), 2:(41, 'Nb'), 3:(73, 'Ta'), 4:(74, 'W')}

#with open(xyzname,'w') as XYZ:
i=1
for (l,r,c) in allCoords:
    x=l/float(L) ; y=r/float(L) ; z=c/float(L)
    (a,b)=species[sig[l,r,c]]
    print('%2.10f %2.10f %2.10f %2d %3d' % (x,y,z,a,i))
    i+=1
